using System;

class Program
{
    static int SimulateTournament(int[] strengths, int numRounds)
    {
        int n = strengths.Length;
        for (int round = 1; round <= numRounds; round++)
        {
            int[] winners = new int[n / (int)Math.Pow(2, round - 1)];
            for (int i = 0; i < n / (int)Math.Pow(2, round - 1); i++)
            {
                int firstIdx = i * 2;
                int secondIdx = i * 2 + 1;
                winners[i] = strengths[firstIdx] > strengths[secondIdx] ? firstIdx : secondIdx;
            }
            strengths = winners;
        }
        return strengths[0];
    }

    static void Main()
    {
        int N = int.Parse(Console.ReadLine());
        int[] strengths = Array.ConvertAll(Console.ReadLine().Split(), int.Parse);

        int Q = int.Parse(Console.ReadLine());
        for (int i = 0; i < Q; i++)
        {
            string[] option = Console.ReadLine().Split();
            int M = int.Parse(option[0]);
            int J = int.Parse(option[1]);

            int[] tempStrengths = (int[])strengths.Clone();
            int highestRound = 0;

            for (int j = 0; j < N - 1; j++)
            {
                for (int k = j + 1; k < N; k++)
                {
                    if (tempStrengths[j] != M && tempStrengths[k] != M && J > 0)
                    {
                        int temp = tempStrengths[j];
                        tempStrengths[j] = tempStrengths[k];
                        tempStrengths[k] = temp;

                        int highest = SimulateTournament(tempStrengths, (int)Math.Log2(N));
                        highestRound = Math.Max(highestRound, highest);

                        temp = tempStrengths[j];
                        tempStrengths[j] = tempStrengths[k];
                        tempStrengths[k] = temp;

                        J--;
                    }
                }
            }

            Console.WriteLine(highestRound);
        }
    }
}